WRITE    - Write lines to a text file
Manual updated: 2005-12-11

Syntax:
        WRITE -<switches> lines(s)

Description:
WRITE is a utility to allow you to create and update text files 
from the command line. It can be used in batch files to create 
files that depend on some of the batch parameters or environment
variables. 

WRITE is similar to using redirection with the built-in ECHO 
command. However, WRITE handles the parameters differently, 
allowing you to write lines containing multiple words without 
the annoying quote marks (ECHO insists on putting the actual 
quote marks into the output).

It supports the standard show usage (-?), show name (-??), and 
show manual (-?m) switches.

Options:
        -?       Display this message
        -N       New file, delete old contents
        -Ofile   Output file spec

Examples:
	WRITE -Oout.txt "Add this line to the file"
		Add the quoted string to the file 'out.txt'

	WRITE -Oout.txt "One line" "Two lines"
		Add two lines, each containing two words, to 
		the file 'out.txt'

	WRITE -Oout.txt " "
		Append a blank line to a file. 
		This can be useful for separating sections in
		the output file.

	WRITE -Oout.txt " " "Line after blank line"
		Output a blank line, then a text line. 
		This can be useful for adding a title for the 
		next section in the output file.

	WRITE -N -Oout.txt This is a six line file
		Clear the output file, then write six lines,
		each containing a single word, to the output file

	WRITE -N -Onew.bat "REM Batch file to display %1"
		Create a new batch file and place a comment at
		the top, incorporating one of the parameters 
		to the current batch file.

Batch file to create a date-stamped directory listing:
Create a file containing a title, a date-stamp,	a blank line, 
and a listing of the current directory. 
	WRITE -N -Odir.txt "Directory listing as of"
	DATE  /T >>dir.txt
	WRITE    -Odir.txt " "
	DIR      >>dir.txt

Notes:
You must specify an output file (-o). There is no default output file. 

If you want a blank line in the file, tell WRITE to output a line 
containing a single blank. 
